@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents an incident comment
 * @property author Describes the client that created the comment
 * @property createdTimeUtc The time the comment was created
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModifiedTimeUtc The time the comment was updated
 * @property message The comment message
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetIncidentCommentResult(
    public val author: ClientInfoResponse,
    public val createdTimeUtc: String,
    public val etag: String? = null,
    public val id: String,
    public val lastModifiedTimeUtc: String,
    public val message: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetIncidentCommentResult): GetIncidentCommentResult = GetIncidentCommentResult(
            author = javaType.author().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.ClientInfoResponse.Companion.toKotlin(args0)
            }),
            createdTimeUtc = javaType.createdTimeUtc(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModifiedTimeUtc = javaType.lastModifiedTimeUtc(),
            message = javaType.message(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
