@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * GetInsights Query Errors.
 * @property errorMessage the error message
 * @property kind the query kind
 * @property queryId the query id
 */
public data class GetInsightsErrorKindResponse(
    public val errorMessage: String,
    public val kind: String,
    public val queryId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetInsightsErrorKindResponse): GetInsightsErrorKindResponse = GetInsightsErrorKindResponse(
            errorMessage = javaType.errorMessage(),
            kind = javaType.kind(),
            queryId = javaType.queryId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
