@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents scheduled alert rule.
 * @property alertDetailsOverride The alert details override settings
 * @property alertRuleTemplateName The Name of the alert rule template used to create this rule.
 * @property customDetails Dictionary of string key-value pairs of columns to be attached to the alert
 * @property description The description of the alert rule.
 * @property displayName The display name for alerts created by this alert rule.
 * @property enabled Determines whether this alert rule is enabled or disabled.
 * @property entityMappings Array of the entity mappings of the alert rule
 * @property etag Etag of the azure resource
 * @property eventGroupingSettings The event grouping settings.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property incidentConfiguration The settings of the incidents that created from alerts triggered by this analytics rule
 * @property kind The kind of the alert rule
 * Expected value is 'Scheduled'.
 * @property lastModifiedUtc The last time that this alert rule has been modified.
 * @property name The name of the resource
 * @property query The query that creates alerts for this rule.
 * @property queryFrequency The frequency (in ISO 8601 duration format) for this alert rule to run.
 * @property queryPeriod The period (in ISO 8601 duration format) that this alert rule looks at.
 * @property severity The severity for alerts created by this alert rule.
 * @property suppressionDuration The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
 * @property suppressionEnabled Determines whether the suppression for this alert rule is enabled or disabled.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tactics The tactics of the alert rule
 * @property techniques The techniques of the alert rule
 * @property templateVersion The version of the alert rule template used to create this rule - in format <a.b.c>, where all are numbers, for example 0 <1.0.2>
 * @property triggerOperator The operation against the threshold that triggers alert rule.
 * @property triggerThreshold The threshold triggers this alert rule.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetScheduledAlertRuleResult(
    public val alertDetailsOverride: AlertDetailsOverrideResponse? = null,
    public val alertRuleTemplateName: String? = null,
    public val customDetails: Map<String, String>? = null,
    public val description: String? = null,
    public val displayName: String,
    public val enabled: Boolean,
    public val entityMappings: List<EntityMappingResponse>? = null,
    public val etag: String? = null,
    public val eventGroupingSettings: EventGroupingSettingsResponse? = null,
    public val id: String,
    public val incidentConfiguration: IncidentConfigurationResponse? = null,
    public val kind: String,
    public val lastModifiedUtc: String,
    public val name: String,
    public val query: String,
    public val queryFrequency: String,
    public val queryPeriod: String,
    public val severity: String,
    public val suppressionDuration: String,
    public val suppressionEnabled: Boolean,
    public val systemData: SystemDataResponse,
    public val tactics: List<String>? = null,
    public val techniques: List<String>? = null,
    public val templateVersion: String? = null,
    public val triggerOperator: String,
    public val triggerThreshold: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetScheduledAlertRuleResult): GetScheduledAlertRuleResult = GetScheduledAlertRuleResult(
            alertDetailsOverride = javaType.alertDetailsOverride().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AlertDetailsOverrideResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            alertRuleTemplateName = javaType.alertRuleTemplateName().map({ args0 -> args0 }).orElse(null),
            customDetails = javaType.customDetails().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName(),
            enabled = javaType.enabled(),
            entityMappings = javaType.entityMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EntityMappingResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            eventGroupingSettings = javaType.eventGroupingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.EventGroupingSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            incidentConfiguration = javaType.incidentConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind(),
            lastModifiedUtc = javaType.lastModifiedUtc(),
            name = javaType.name(),
            query = javaType.query(),
            queryFrequency = javaType.queryFrequency(),
            queryPeriod = javaType.queryPeriod(),
            severity = javaType.severity(),
            suppressionDuration = javaType.suppressionDuration(),
            suppressionEnabled = javaType.suppressionEnabled(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tactics = javaType.tactics().map({ args0 -> args0 }),
            techniques = javaType.techniques().map({ args0 -> args0 }),
            templateVersion = javaType.templateVersion().map({ args0 -> args0 }).orElse(null),
            triggerOperator = javaType.triggerOperator(),
            triggerThreshold = javaType.triggerThreshold(),
            type = javaType.type(),
        )
    }
}
