@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Represents a Watchlist Item in Azure Security Insights.
 * @property created The time the watchlist item was created
 * @property createdBy Describes a user that created the watchlist item
 * @property entityMapping key-value pairs for a watchlist item entity mapping
 * @property etag Etag of the azure resource
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isDeleted A flag that indicates if the watchlist item is deleted or not
 * @property itemsKeyValue key-value pairs for a watchlist item
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tenantId The tenantId to which the watchlist item belongs to
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updated The last time the watchlist item was updated
 * @property updatedBy Describes a user that updated the watchlist item
 * @property watchlistItemId The id (a Guid) of the watchlist item
 * @property watchlistItemType The type of the watchlist item
 */
public data class GetWatchlistItemResult(
    public val created: String? = null,
    public val createdBy: WatchlistUserInfoResponse? = null,
    public val entityMapping: Any? = null,
    public val etag: String? = null,
    public val id: String,
    public val isDeleted: Boolean? = null,
    public val itemsKeyValue: Any,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val tenantId: String? = null,
    public val type: String,
    public val updated: String? = null,
    public val updatedBy: WatchlistUserInfoResponse? = null,
    public val watchlistItemId: String? = null,
    public val watchlistItemType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GetWatchlistItemResult): GetWatchlistItemResult = GetWatchlistItemResult(
            created = javaType.created().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            entityMapping = javaType.entityMapping().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isDeleted = javaType.isDeleted().map({ args0 -> args0 }).orElse(null),
            itemsKeyValue = javaType.itemsKeyValue(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.securityinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updated = javaType.updated().map({ args0 -> args0 }).orElse(null),
            updatedBy = javaType.updatedBy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.WatchlistUserInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            watchlistItemId = javaType.watchlistItemId().map({ args0 -> args0 }).orElse(null),
            watchlistItemType = javaType.watchlistItemType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
