@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The graph query to show the volume of data arriving into the workspace over time.
 * @property baseQuery Gets or sets the base query for the graph.
 * The base query is wrapped by Sentinel UI infra with a KQL query, that measures the volume over time.
 * @property legend Gets or sets the legend for the graph.
 * @property metricName Gets or sets the metric name that the query is checking. For example: 'Total data receive'.
 */
public data class GraphQueryResponse(
    public val baseQuery: String,
    public val legend: String,
    public val metricName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.GraphQueryResponse): GraphQueryResponse = GraphQueryResponse(
            baseQuery = javaType.baseQuery(),
            legend = javaType.legend(),
            metricName = javaType.metricName(),
        )
    }
}
