@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Incident additional data property bag.
 * @property alertProductNames List of product names of alerts in the incident
 * @property alertsCount The number of alerts in the incident
 * @property bookmarksCount The number of bookmarks in the incident
 * @property commentsCount The number of comments in the incident
 * @property providerIncidentUrl The provider incident url to the incident in Microsoft 365 Defender portal
 * @property tactics The tactics associated with incident
 */
public data class IncidentAdditionalDataResponse(
    public val alertProductNames: List<String>,
    public val alertsCount: Int,
    public val bookmarksCount: Int,
    public val commentsCount: Int,
    public val providerIncidentUrl: String,
    public val tactics: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.IncidentAdditionalDataResponse): IncidentAdditionalDataResponse = IncidentAdditionalDataResponse(
            alertProductNames = javaType.alertProductNames().map({ args0 -> args0 }),
            alertsCount = javaType.alertsCount(),
            bookmarksCount = javaType.bookmarksCount(),
            commentsCount = javaType.commentsCount(),
            providerIncidentUrl = javaType.providerIncidentUrl(),
            tactics = javaType.tactics().map({ args0 -> args0 }),
        )
    }
}
