@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Incident Configuration property bag.
 * @property createIncident Create incidents from alerts triggered by this analytics rule
 * @property groupingConfiguration Set how the alerts that are triggered by this analytics rule, are grouped into incidents
 */
public data class IncidentConfigurationResponse(
    public val createIncident: Boolean,
    public val groupingConfiguration: GroupingConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.IncidentConfigurationResponse): IncidentConfigurationResponse = IncidentConfigurationResponse(
            createIncident = javaType.createIncident(),
            groupingConfiguration = javaType.groupingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.GroupingConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
