@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes related incident information for the bookmark
 * @property incidentId Incident Id
 * @property relationName Relation Name
 * @property severity The severity of the incident
 * @property title The title of the incident
 */
public data class IncidentInfoResponse(
    public val incidentId: String? = null,
    public val relationName: String? = null,
    public val severity: String? = null,
    public val title: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.IncidentInfoResponse): IncidentInfoResponse = IncidentInfoResponse(
            incidentId = javaType.incidentId().map({ args0 -> args0 }).orElse(null),
            relationName = javaType.relationName().map({ args0 -> args0 }).orElse(null),
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
        )
    }
}
