@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property classification The reason the incident was closed
 * @property classificationComment Describes the reason the incident was closed.
 * @property classificationReason The classification reason the incident was closed with
 * @property labels List of labels to add to the incident.
 * @property owner Information on the user an incident is assigned to
 * @property severity The severity of the incident
 * @property status The status of the incident
 */
public data class IncidentPropertiesActionResponse(
    public val classification: String? = null,
    public val classificationComment: String? = null,
    public val classificationReason: String? = null,
    public val labels: List<IncidentLabelResponse>? = null,
    public val owner: IncidentOwnerInfoResponse? = null,
    public val severity: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.IncidentPropertiesActionResponse): IncidentPropertiesActionResponse = IncidentPropertiesActionResponse(
            classification = javaType.classification().map({ args0 -> args0 }).orElse(null),
            classificationComment = javaType.classificationComment().map({ args0 -> args0 }).orElse(null),
            classificationReason = javaType.classificationReason().map({ args0 -> args0 }).orElse(null),
            labels = javaType.labels().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentLabelResponse.Companion.toKotlin(args0)
                })
            }),
            owner = javaType.owner().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.IncidentOwnerInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            severity = javaType.severity().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
