@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Instruction steps to enable the connector.
 * @property description Gets or sets the instruction step description.
 * @property innerSteps Gets or sets the inner instruction steps details.
 * Foe Example: instruction step 1 might contain inner instruction steps: [instruction step 1&#46;1, instruction step 1&#46;2].
 * @property instructions Gets or sets the instruction step details.
 * @property title Gets or sets the instruction step title.
 */
public data class InstructionStepResponse(
    public val description: String? = null,
    public val innerSteps: List<InstructionStepResponse>? = null,
    public val instructions: List<InstructionStepDetailsResponse>? = null,
    public val title: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.InstructionStepResponse): InstructionStepResponse = InstructionStepResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            innerSteps = javaType.innerSteps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.InstructionStepResponse.Companion.toKotlin(args0)
                })
            }),
            instructions = javaType.instructions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.InstructionStepDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
        )
    }
}
