@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Geodata information for a given IP address
 * @property asn The autonomous system number associated with this IP address
 * @property carrier The name of the carrier for this IP address
 * @property city The city this IP address is located in
 * @property cityConfidenceFactor A numeric rating of confidence that the value in the 'city' field is correct, on a scale of 0-100
 * @property continent The continent this IP address is located on
 * @property country The county this IP address is located in
 * @property countryConfidenceFactor A numeric rating of confidence that the value in the 'country' field is correct on a scale of 0-100
 * @property ipAddr The dotted-decimal or colon-separated string representation of the IP address
 * @property ipRoutingType A description of the connection type of this IP address
 * @property latitude The latitude of this IP address
 * @property longitude The longitude of this IP address
 * @property organization The name of the organization for this IP address
 * @property organizationType The type of the organization for this IP address
 * @property region The geographic region this IP address is located in
 * @property state The state this IP address is located in
 * @property stateCode The abbreviated name for the state this IP address is located in
 * @property stateConfidenceFactor A numeric rating of confidence that the value in the 'state' field is correct on a scale of 0-100
 */
public data class ListGeodataByIpResult(
    public val asn: String? = null,
    public val carrier: String? = null,
    public val city: String? = null,
    public val cityConfidenceFactor: Int? = null,
    public val continent: String? = null,
    public val country: String? = null,
    public val countryConfidenceFactor: Int? = null,
    public val ipAddr: String? = null,
    public val ipRoutingType: String? = null,
    public val latitude: String? = null,
    public val longitude: String? = null,
    public val organization: String? = null,
    public val organizationType: String? = null,
    public val region: String? = null,
    public val state: String? = null,
    public val stateCode: String? = null,
    public val stateConfidenceFactor: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ListGeodataByIpResult): ListGeodataByIpResult = ListGeodataByIpResult(
            asn = javaType.asn().map({ args0 -> args0 }).orElse(null),
            carrier = javaType.carrier().map({ args0 -> args0 }).orElse(null),
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            cityConfidenceFactor = javaType.cityConfidenceFactor().map({ args0 -> args0 }).orElse(null),
            continent = javaType.continent().map({ args0 -> args0 }).orElse(null),
            country = javaType.country().map({ args0 -> args0 }).orElse(null),
            countryConfidenceFactor = javaType.countryConfidenceFactor().map({ args0 -> args0 }).orElse(null),
            ipAddr = javaType.ipAddr().map({ args0 -> args0 }).orElse(null),
            ipRoutingType = javaType.ipRoutingType().map({ args0 -> args0 }).orElse(null),
            latitude = javaType.latitude().map({ args0 -> args0 }).orElse(null),
            longitude = javaType.longitude().map({ args0 -> args0 }).orElse(null),
            organization = javaType.organization().map({ args0 -> args0 }).orElse(null),
            organizationType = javaType.organizationType().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            stateCode = javaType.stateCode().map({ args0 -> args0 }).orElse(null),
            stateConfidenceFactor = javaType.stateConfidenceFactor().map({ args0 -> args0 }).orElse(null),
        )
    }
}
