@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List all the source controls.
 * @property nextLink URL to fetch the next set of repositories.
 * @property value Array of repositories.
 */
public data class ListSourceControlRepositoriesResult(
    public val nextLink: String,
    public val `value`: List<RepoResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ListSourceControlRepositoriesResult): ListSourceControlRepositoriesResult = ListSourceControlRepositoriesResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.RepoResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
