@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Suppress

/**
 * The available data types for MCAS (Microsoft Cloud App Security) data connector.
 * @property alerts Alerts data type connection.
 * @property discoveryLogs Discovery log data type connection.
 */
public data class MCASDataConnectorDataTypesResponse(
    public val alerts: DataConnectorDataTypeCommonResponse? = null,
    public val discoveryLogs: DataConnectorDataTypeCommonResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.MCASDataConnectorDataTypesResponse): MCASDataConnectorDataTypesResponse = MCASDataConnectorDataTypesResponse(
            alerts = javaType.alerts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.DataConnectorDataTypeCommonResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            discoveryLogs = javaType.discoveryLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.DataConnectorDataTypeCommonResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
