@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Publisher or creator of the content item.
 * @property email Email of author contact
 * @property link Link for author/vendor page
 * @property name Name of the author. Company or person.
 */
public data class MetadataAuthorResponse(
    public val email: String? = null,
    public val link: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.MetadataAuthorResponse): MetadataAuthorResponse = MetadataAuthorResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            link = javaType.link().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
