@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The original source of the content item, where it comes from.
 * @property kind Source type of the content
 * @property name Name of the content source.  The repo name, solution name, LA workspace name etc.
 * @property sourceId ID of the content source.  The solution ID, workspace ID, etc
 */
public data class MetadataSourceResponse(
    public val kind: String,
    public val name: String? = null,
    public val sourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.MetadataSourceResponse): MetadataSourceResponse = MetadataSourceResponse(
            kind = javaType.kind(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sourceId = javaType.sourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
