@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a repository.
 * @property branches Array of branches.
 * @property fullName The name of the repository.
 * @property url The url to access the repository.
 */
public data class RepoResponse(
    public val branches: List<String>? = null,
    public val fullName: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.RepoResponse): RepoResponse = RepoResponse(
            branches = javaType.branches().map({ args0 -> args0 }),
            fullName = javaType.fullName().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
