@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Suppress

/**
 * Resources created in user's repository for the source-control.
 * @property azureDevOpsResourceInfo Resources created in Azure DevOps for this source-control.
 * @property gitHubResourceInfo Resources created in GitHub for this source-control.
 * @property webhook The webhook object created for the source-control.
 */
public data class RepositoryResourceInfoResponse(
    public val azureDevOpsResourceInfo: AzureDevOpsResourceInfoResponse? = null,
    public val gitHubResourceInfo: GitHubResourceInfoResponse? = null,
    public val webhook: WebhookResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.RepositoryResourceInfoResponse): RepositoryResourceInfoResponse = RepositoryResourceInfoResponse(
            azureDevOpsResourceInfo = javaType.azureDevOpsResourceInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.AzureDevOpsResourceInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gitHubResourceInfo = javaType.gitHubResourceInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.GitHubResourceInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            webhook = javaType.webhook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.WebhookResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
