@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * security ml analytics settings data sources
 * @property connectorId The connector id that provides the following data types
 * @property dataTypes The data types used by the security ml analytics settings
 */
public data class SecurityMLAnalyticsSettingsDataSourceResponse(
    public val connectorId: String? = null,
    public val dataTypes: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.SecurityMLAnalyticsSettingsDataSourceResponse): SecurityMLAnalyticsSettingsDataSourceResponse =
            SecurityMLAnalyticsSettingsDataSourceResponse(
                connectorId = javaType.connectorId().map({ args0 -> args0 }).orElse(null),
                dataTypes = javaType.dataTypes().map({ args0 -> args0 }),
            )
    }
}
