@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * timeline aggregation information per kind
 * @property count the total items found for a kind
 * @property kind the query kind
 */
public data class TimelineAggregationResponse(
    public val count: Int,
    public val kind: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.TimelineAggregationResponse): TimelineAggregationResponse = TimelineAggregationResponse(
            count = javaType.count(),
            kind = javaType.kind(),
        )
    }
}
