@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Timeline Query Errors.
 * @property errorMessage the error message
 * @property kind the query kind
 * @property queryId the query id
 */
public data class TimelineErrorResponse(
    public val errorMessage: String,
    public val kind: String,
    public val queryId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.TimelineErrorResponse): TimelineErrorResponse = TimelineErrorResponse(
            errorMessage = javaType.errorMessage(),
            kind = javaType.kind(),
            queryId = javaType.queryId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
