@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Expansion result metadata.
 * @property aggregations timeline aggregation per kind
 * @property errors information about the failure queries
 * @property totalCount the total items found for the timeline request
 */
public data class TimelineResultsMetadataResponse(
    public val aggregations: List<TimelineAggregationResponse>,
    public val errors: List<TimelineErrorResponse>? = null,
    public val totalCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.TimelineResultsMetadataResponse): TimelineResultsMetadataResponse = TimelineResultsMetadataResponse(
            aggregations = javaType.aggregations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.TimelineAggregationResponse.Companion.toKotlin(args0)
                })
            }),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.securityinsights.kotlin.outputs.TimelineErrorResponse.Companion.toKotlin(args0)
                })
            }),
            totalCount = javaType.totalCount(),
        )
    }
}
