@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.serialconsole.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SerialPort].
 */
@PulumiTagMarker
public class SerialPortResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SerialPortArgs = SerialPortArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SerialPortArgsBuilder.() -> Unit) {
        val builder = SerialPortArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SerialPort {
        val builtJavaResource = com.pulumi.azurenative.serialconsole.SerialPort(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SerialPort(builtJavaResource)
    }
}

/**
 * Represents the serial port of the parent resource.
 * Azure REST API version: 2018-05-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * ## Example Usage
 * ### Create a new serial port resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serialPort = new AzureNative.SerialConsole.SerialPort("serialPort", new()
 *     {
 *         ParentResource = "myVM",
 *         ParentResourceType = "virtualMachines",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceProviderNamespace = "Microsoft.Compute",
 *         SerialPort = "0",
 *         State = AzureNative.SerialConsole.SerialPortState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/serialconsole/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := serialconsole.NewSerialPort(ctx, "serialPort", &serialconsole.SerialPortArgs{
 * 			ParentResource:            pulumi.String("myVM"),
 * 			ParentResourceType:        pulumi.String("virtualMachines"),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 			ResourceProviderNamespace: pulumi.String("Microsoft.Compute"),
 * 			SerialPort:                pulumi.String("0"),
 * 			State:                     serialconsole.SerialPortStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.serialconsole.SerialPort;
 * import com.pulumi.azurenative.serialconsole.SerialPortArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serialPort = new SerialPort("serialPort", SerialPortArgs.builder()
 *             .parentResource("myVM")
 *             .parentResourceType("virtualMachines")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceProviderNamespace("Microsoft.Compute")
 *             .serialPort("0")
 *             .state("enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:serialconsole:SerialPort 0 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourceType}/{parentResource}/providers/Microsoft.SerialConsole/serialPorts/{serialPort}
 * ```
 */
public class SerialPort internal constructor(
    override val javaResource: com.pulumi.azurenative.serialconsole.SerialPort,
) : KotlinCustomResource(javaResource, SerialPortMapper) {
    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the port is enabled for a serial console connection.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SerialPortMapper : ResourceMapper<SerialPort> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.serialconsole.SerialPort::class == javaResource::class

    override fun map(javaResource: Resource): SerialPort = SerialPort(
        javaResource as
            com.pulumi.azurenative.serialconsole.SerialPort,
    )
}

/**
 * @see [SerialPort].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SerialPort].
 */
public suspend fun serialPort(name: String, block: suspend SerialPortResourceBuilder.() -> Unit): SerialPort {
    val builder = SerialPortResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SerialPort].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serialPort(name: String): SerialPort {
    val builder = SerialPortResourceBuilder()
    builder.name(name)
    return builder.build()
}
