@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.serialconsole.kotlin

import com.pulumi.azurenative.serialconsole.SerialPortArgs.builder
import com.pulumi.azurenative.serialconsole.kotlin.enums.SerialPortState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the serial port of the parent resource.
 * Azure REST API version: 2018-05-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * ## Example Usage
 * ### Create a new serial port resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serialPort = new AzureNative.SerialConsole.SerialPort("serialPort", new()
 *     {
 *         ParentResource = "myVM",
 *         ParentResourceType = "virtualMachines",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceProviderNamespace = "Microsoft.Compute",
 *         SerialPort = "0",
 *         State = AzureNative.SerialConsole.SerialPortState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/serialconsole/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := serialconsole.NewSerialPort(ctx, "serialPort", &serialconsole.SerialPortArgs{
 * 			ParentResource:            pulumi.String("myVM"),
 * 			ParentResourceType:        pulumi.String("virtualMachines"),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 			ResourceProviderNamespace: pulumi.String("Microsoft.Compute"),
 * 			SerialPort:                pulumi.String("0"),
 * 			State:                     serialconsole.SerialPortStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.serialconsole.SerialPort;
 * import com.pulumi.azurenative.serialconsole.SerialPortArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serialPort = new SerialPort("serialPort", SerialPortArgs.builder()
 *             .parentResource("myVM")
 *             .parentResourceType("virtualMachines")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceProviderNamespace("Microsoft.Compute")
 *             .serialPort("0")
 *             .state("enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:serialconsole:SerialPort 0 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourceType}/{parentResource}/providers/Microsoft.SerialConsole/serialPorts/{serialPort}
 * ```
 * @property parentResource The resource name, or subordinate path, for the parent of the serial port. For example: the name of the virtual machine.
 * @property parentResourceType The resource type of the parent resource.  For example: 'virtualMachines' or 'virtualMachineScaleSets'
 * @property resourceGroupName The name of the resource group.
 * @property resourceProviderNamespace The namespace of the resource provider.
 * @property serialPort The name of the serial port to create.
 * @property state Specifies whether the port is enabled for a serial console connection.
 */
public data class SerialPortArgs(
    public val parentResource: Output<String>? = null,
    public val parentResourceType: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceProviderNamespace: Output<String>? = null,
    public val serialPort: Output<String>? = null,
    public val state: Output<SerialPortState>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.serialconsole.SerialPortArgs> {
    override fun toJava(): com.pulumi.azurenative.serialconsole.SerialPortArgs =
        com.pulumi.azurenative.serialconsole.SerialPortArgs.builder()
            .parentResource(parentResource?.applyValue({ args0 -> args0 }))
            .parentResourceType(parentResourceType?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceProviderNamespace(resourceProviderNamespace?.applyValue({ args0 -> args0 }))
            .serialPort(serialPort?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SerialPortArgs].
 */
@PulumiTagMarker
public class SerialPortArgsBuilder internal constructor() {
    private var parentResource: Output<String>? = null

    private var parentResourceType: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceProviderNamespace: Output<String>? = null

    private var serialPort: Output<String>? = null

    private var state: Output<SerialPortState>? = null

    /**
     * @param value The resource name, or subordinate path, for the parent of the serial port. For example: the name of the virtual machine.
     */
    @JvmName("usfcigdnsvptqlon")
    public suspend fun parentResource(`value`: Output<String>) {
        this.parentResource = value
    }

    /**
     * @param value The resource type of the parent resource.  For example: 'virtualMachines' or 'virtualMachineScaleSets'
     */
    @JvmName("tvlufsfwhlrufrmd")
    public suspend fun parentResourceType(`value`: Output<String>) {
        this.parentResourceType = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("irrrgythqihgggli")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The namespace of the resource provider.
     */
    @JvmName("ihjdilnslwrsuxml")
    public suspend fun resourceProviderNamespace(`value`: Output<String>) {
        this.resourceProviderNamespace = value
    }

    /**
     * @param value The name of the serial port to create.
     */
    @JvmName("wuhejgjqjugukpgq")
    public suspend fun serialPort(`value`: Output<String>) {
        this.serialPort = value
    }

    /**
     * @param value Specifies whether the port is enabled for a serial console connection.
     */
    @JvmName("jmuywkxmbvdjtnyw")
    public suspend fun state(`value`: Output<SerialPortState>) {
        this.state = value
    }

    /**
     * @param value The resource name, or subordinate path, for the parent of the serial port. For example: the name of the virtual machine.
     */
    @JvmName("munoyepkxkrnhmrd")
    public suspend fun parentResource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResource = mapped
    }

    /**
     * @param value The resource type of the parent resource.  For example: 'virtualMachines' or 'virtualMachineScaleSets'
     */
    @JvmName("sohfhjnodrsalpmi")
    public suspend fun parentResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResourceType = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ermqgycjgcjuafkt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The namespace of the resource provider.
     */
    @JvmName("mrvmqototpglesli")
    public suspend fun resourceProviderNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProviderNamespace = mapped
    }

    /**
     * @param value The name of the serial port to create.
     */
    @JvmName("mgwkvjfawkrqsmhf")
    public suspend fun serialPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialPort = mapped
    }

    /**
     * @param value Specifies whether the port is enabled for a serial console connection.
     */
    @JvmName("fvxpngkwanpavvkh")
    public suspend fun state(`value`: SerialPortState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SerialPortArgs = SerialPortArgs(
        parentResource = parentResource,
        parentResourceType = parentResourceType,
        resourceGroupName = resourceGroupName,
        resourceProviderNamespace = resourceProviderNamespace,
        serialPort = serialPort,
        state = state,
    )
}
