@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.MigrationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Single item in List or Get Migration Config operation
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### MigrationConfigurationsStartMigration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrationConfig = new AzureNative.ServiceBus.MigrationConfig("migrationConfig", new()
 *     {
 *         ConfigName = "$default",
 *         NamespaceName = "sdk-Namespace-41",
 *         PostMigrationName = "sdk-PostMigration-5919",
 *         ResourceGroupName = "ResourceGroup",
 *         TargetNamespace = "/subscriptions/SubscriptionId/resourceGroups/ResourceGroup/providers/Microsoft.ServiceBus/namespaces/sdk-Namespace-4028",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewMigrationConfig(ctx, "migrationConfig", &servicebus.MigrationConfigArgs{
 * 			ConfigName:        pulumi.String("$default"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-41"),
 * 			PostMigrationName: pulumi.String("sdk-PostMigration-5919"),
 * 			ResourceGroupName: pulumi.String("ResourceGroup"),
 * 			TargetNamespace:   pulumi.String("/subscriptions/SubscriptionId/resourceGroups/ResourceGroup/providers/Microsoft.ServiceBus/namespaces/sdk-Namespace-4028"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.MigrationConfig;
 * import com.pulumi.azurenative.servicebus.MigrationConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrationConfig = new MigrationConfig("migrationConfig", MigrationConfigArgs.builder()
 *             .configName("$default")
 *             .namespaceName("sdk-Namespace-41")
 *             .postMigrationName("sdk-PostMigration-5919")
 *             .resourceGroupName("ResourceGroup")
 *             .targetNamespace("/subscriptions/SubscriptionId/resourceGroups/ResourceGroup/providers/Microsoft.ServiceBus/namespaces/sdk-Namespace-4028")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:MigrationConfig sdk-Namespace-41 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/migrationConfigurations/{configName}
 * ```
 * @property configName The configuration name. Should always be "$default".
 * @property namespaceName The namespace name
 * @property postMigrationName Name to access Standard Namespace after migration
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property targetNamespace Existing premium Namespace ARM Id name which has no entities, will be used for migration
 */
public data class MigrationConfigArgs(
    public val configName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val postMigrationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val targetNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.MigrationConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.MigrationConfigArgs =
        com.pulumi.azurenative.servicebus.MigrationConfigArgs.builder()
            .configName(configName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .postMigrationName(postMigrationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .targetNamespace(targetNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrationConfigArgs].
 */
@PulumiTagMarker
public class MigrationConfigArgsBuilder internal constructor() {
    private var configName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var postMigrationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var targetNamespace: Output<String>? = null

    /**
     * @param value The configuration name. Should always be "$default".
     */
    @JvmName("iewfwpkbhpalnrgv")
    public suspend fun configName(`value`: Output<String>) {
        this.configName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("wvajsyxjgsmxeeha")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name to access Standard Namespace after migration
     */
    @JvmName("wowyutamoqahnqfl")
    public suspend fun postMigrationName(`value`: Output<String>) {
        this.postMigrationName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("khisodfjjpxdxigu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Existing premium Namespace ARM Id name which has no entities, will be used for migration
     */
    @JvmName("guqcpntefoyustkk")
    public suspend fun targetNamespace(`value`: Output<String>) {
        this.targetNamespace = value
    }

    /**
     * @param value The configuration name. Should always be "$default".
     */
    @JvmName("yjiehieqhiqrrscv")
    public suspend fun configName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("mwsdxjauttpwawhc")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name to access Standard Namespace after migration
     */
    @JvmName("nwnmrsvyujdvjvoe")
    public suspend fun postMigrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postMigrationName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("uebxoqdhqfiswquw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Existing premium Namespace ARM Id name which has no entities, will be used for migration
     */
    @JvmName("gkrfvmeljxhigqwt")
    public suspend fun targetNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNamespace = mapped
    }

    internal fun build(): MigrationConfigArgs = MigrationConfigArgs(
        configName = configName,
        namespaceName = namespaceName,
        postMigrationName = postMigrationName,
        resourceGroupName = resourceGroupName,
        targetNamespace = targetNamespace,
    )
}
