@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Single item in a List or Get VirtualNetworkRules operation
 * Azure REST API version: 2018-01-01-preview. Prior API version in Azure Native 1.x: 2018-01-01-preview.
 * ## Example Usage
 * ### NameSpaceVirtualNetworkRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceVirtualNetworkRule = new AzureNative.ServiceBus.NamespaceVirtualNetworkRule("namespaceVirtualNetworkRule", new()
 *     {
 *         NamespaceName = "sdk-Namespace-6019",
 *         ResourceGroupName = "ResourceGroup",
 *         VirtualNetworkRuleName = "sdk-VirtualNetworkRules-9191",
 *         VirtualNetworkSubnetId = "/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewNamespaceVirtualNetworkRule(ctx, "namespaceVirtualNetworkRule", &servicebus.NamespaceVirtualNetworkRuleArgs{
 * 			NamespaceName:          pulumi.String("sdk-Namespace-6019"),
 * 			ResourceGroupName:      pulumi.String("ResourceGroup"),
 * 			VirtualNetworkRuleName: pulumi.String("sdk-VirtualNetworkRules-9191"),
 * 			VirtualNetworkSubnetId: pulumi.String("/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRule;
 * import com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceVirtualNetworkRule = new NamespaceVirtualNetworkRule("namespaceVirtualNetworkRule", NamespaceVirtualNetworkRuleArgs.builder()
 *             .namespaceName("sdk-Namespace-6019")
 *             .resourceGroupName("ResourceGroup")
 *             .virtualNetworkRuleName("sdk-VirtualNetworkRules-9191")
 *             .virtualNetworkSubnetId("/subscriptions/Subscription/resourceGroups/sbehvnettest/providers/Microsoft.Network/virtualNetworks/sbehvnettest/subnets/default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:NamespaceVirtualNetworkRule sdk-VirtualNetworkRules-9191 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/virtualnetworkrules/{virtualNetworkRuleName}
 * ```
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property virtualNetworkRuleName The Virtual Network Rule name.
 * @property virtualNetworkSubnetId Resource ID of Virtual Network Subnet
 */
public data class NamespaceVirtualNetworkRuleArgs(
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualNetworkRuleName: Output<String>? = null,
    public val virtualNetworkSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRuleArgs =
        com.pulumi.azurenative.servicebus.NamespaceVirtualNetworkRuleArgs.builder()
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualNetworkRuleName(virtualNetworkRuleName?.applyValue({ args0 -> args0 }))
            .virtualNetworkSubnetId(virtualNetworkSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceVirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class NamespaceVirtualNetworkRuleArgsBuilder internal constructor() {
    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualNetworkRuleName: Output<String>? = null

    private var virtualNetworkSubnetId: Output<String>? = null

    /**
     * @param value The namespace name
     */
    @JvmName("ojxkysgnsmqayoib")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("opphbhfbxnduvvfs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Virtual Network Rule name.
     */
    @JvmName("htlcahkihmvtrjcg")
    public suspend fun virtualNetworkRuleName(`value`: Output<String>) {
        this.virtualNetworkRuleName = value
    }

    /**
     * @param value Resource ID of Virtual Network Subnet
     */
    @JvmName("urfnoxurbcvgqnfx")
    public suspend fun virtualNetworkSubnetId(`value`: Output<String>) {
        this.virtualNetworkSubnetId = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("xrnahbaofkonkudd")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("mpoujvumbfubcmok")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Virtual Network Rule name.
     */
    @JvmName("gkroesguqkgbvrxl")
    public suspend fun virtualNetworkRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRuleName = mapped
    }

    /**
     * @param value Resource ID of Virtual Network Subnet
     */
    @JvmName("ldahnxqwijxgyjnq")
    public suspend fun virtualNetworkSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkSubnetId = mapped
    }

    internal fun build(): NamespaceVirtualNetworkRuleArgs = NamespaceVirtualNetworkRuleArgs(
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        virtualNetworkRuleName = virtualNetworkRuleName,
        virtualNetworkSubnetId = virtualNetworkSubnetId,
    )
}
