@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.MessageCountDetailsResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicebus.kotlin.outputs.MessageCountDetailsResponse.Companion.toKotlin as messageCountDetailsResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Queue].
 */
@PulumiTagMarker
public class QueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueueArgs = QueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueueArgsBuilder.() -> Unit) {
        val builder = QueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Queue {
        val builtJavaResource = com.pulumi.azurenative.servicebus.Queue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Queue(builtJavaResource)
    }
}

/**
 * Description of queue Resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### QueueCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AzureNative.ServiceBus.Queue("queue", new()
 *     {
 *         EnablePartitioning = true,
 *         NamespaceName = "sdk-Namespace-3174",
 *         QueueName = "sdk-Queues-5647",
 *         ResourceGroupName = "ArunMonocle",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewQueue(ctx, "queue", &servicebus.QueueArgs{
 * 			EnablePartitioning: pulumi.Bool(true),
 * 			NamespaceName:      pulumi.String("sdk-Namespace-3174"),
 * 			QueueName:          pulumi.String("sdk-Queues-5647"),
 * 			ResourceGroupName:  pulumi.String("ArunMonocle"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Queue;
 * import com.pulumi.azurenative.servicebus.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .enablePartitioning(true)
 *             .namespaceName("sdk-Namespace-3174")
 *             .queueName("sdk-Queues-5647")
 *             .resourceGroupName("ArunMonocle")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Queue sdk-Queues-5647 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}
 * ```
 */
public class Queue internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.Queue,
) : KotlinCustomResource(javaResource, QueueMapper) {
    /**
     * Last time a message was sent, or the last time there was a receive request to this queue.
     */
    public val accessedAt: Output<String>
        get() = javaResource.accessedAt().applyValue({ args0 -> args0 })

    /**
     * ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
     */
    public val autoDeleteOnIdle: Output<String>?
        get() = javaResource.autoDeleteOnIdle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Message Count Details.
     */
    public val countDetails: Output<MessageCountDetailsResponse>
        get() = javaResource.countDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                messageCountDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The exact time the message was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * A value that indicates whether this queue has dead letter support when a message expires.
     */
    public val deadLetteringOnMessageExpiration: Output<Boolean>?
        get() = javaResource.deadLetteringOnMessageExpiration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    public val defaultMessageTimeToLive: Output<String>?
        get() = javaResource.defaultMessageTimeToLive().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    public val duplicateDetectionHistoryTimeWindow: Output<String>?
        get() = javaResource.duplicateDetectionHistoryTimeWindow().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Value that indicates whether server-side batched operations are enabled.
     */
    public val enableBatchedOperations: Output<Boolean>?
        get() = javaResource.enableBatchedOperations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
     */
    public val enableExpress: Output<Boolean>?
        get() = javaResource.enableExpress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A value that indicates whether the queue is to be partitioned across multiple message brokers.
     */
    public val enablePartitioning: Output<Boolean>?
        get() = javaResource.enablePartitioning().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Queue/Topic name to forward the Dead Letter message
     */
    public val forwardDeadLetteredMessagesTo: Output<String>?
        get() = javaResource.forwardDeadLetteredMessagesTo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Queue/Topic name to forward the messages
     */
    public val forwardTo: Output<String>?
        get() = javaResource.forwardTo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
     */
    public val lockDuration: Output<String>?
        get() = javaResource.lockDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
     */
    public val maxDeliveryCount: Output<Int>?
        get() = javaResource.maxDeliveryCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today and default is 1024.
     */
    public val maxMessageSizeInKilobytes: Output<Double>?
        get() = javaResource.maxMessageSizeInKilobytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
     */
    public val maxSizeInMegabytes: Output<Int>?
        get() = javaResource.maxSizeInMegabytes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of messages in the queue.
     */
    public val messageCount: Output<Double>
        get() = javaResource.messageCount().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A value indicating if this queue requires duplicate detection.
     */
    public val requiresDuplicateDetection: Output<Boolean>?
        get() = javaResource.requiresDuplicateDetection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A value that indicates whether the queue supports the concept of sessions.
     */
    public val requiresSession: Output<Boolean>?
        get() = javaResource.requiresSession().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of the queue, in bytes.
     */
    public val sizeInBytes: Output<Double>
        get() = javaResource.sizeInBytes().applyValue({ args0 -> args0 })

    /**
     * Enumerates the possible values for the status of a messaging entity.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The exact time the message was updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object QueueMapper : ResourceMapper<Queue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.Queue::class == javaResource::class

    override fun map(javaResource: Resource): Queue = Queue(
        javaResource as
            com.pulumi.azurenative.servicebus.Queue,
    )
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Queue].
 */
public suspend fun queue(name: String, block: suspend QueueResourceBuilder.() -> Unit): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queue(name: String): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
