@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.RuleArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.FilterType
import com.pulumi.azurenative.servicebus.kotlin.inputs.ActionArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.ActionArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.CorrelationFilterArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.CorrelationFilterArgsBuilder
import com.pulumi.azurenative.servicebus.kotlin.inputs.SqlFilterArgs
import com.pulumi.azurenative.servicebus.kotlin.inputs.SqlFilterArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of Rule Resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### RulesCreateCorrelationFilter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.ServiceBus.Rule("rule", new()
 *     {
 *         CorrelationFilter = new AzureNative.ServiceBus.Inputs.CorrelationFilterArgs
 *         {
 *             Properties =
 *             {
 *                 { "topicHint", "Crop" },
 *             },
 *         },
 *         FilterType = AzureNative.ServiceBus.FilterType.CorrelationFilter,
 *         NamespaceName = "sdk-Namespace-1319",
 *         ResourceGroupName = "resourceGroupName",
 *         RuleName = "sdk-Rules-6571",
 *         SubscriptionName = "sdk-Subscriptions-8691",
 *         TopicName = "sdk-Topics-2081",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewRule(ctx, "rule", &servicebus.RuleArgs{
 * 			CorrelationFilter: &servicebus.CorrelationFilterArgs{
 * 				Properties: pulumi.StringMap{
 * 					"topicHint": pulumi.String("Crop"),
 * 				},
 * 			},
 * 			FilterType:        pulumi.String(servicebus.FilterTypeCorrelationFilter),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-1319"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			RuleName:          pulumi.String("sdk-Rules-6571"),
 * 			SubscriptionName:  pulumi.String("sdk-Subscriptions-8691"),
 * 			TopicName:         pulumi.String("sdk-Topics-2081"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Rule;
 * import com.pulumi.azurenative.servicebus.RuleArgs;
 * import com.pulumi.azurenative.servicebus.inputs.CorrelationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .correlationFilter(CorrelationFilterArgs.builder()
 *                 .properties(Map.of("topicHint", "Crop"))
 *                 .build())
 *             .filterType("CorrelationFilter")
 *             .namespaceName("sdk-Namespace-1319")
 *             .resourceGroupName("resourceGroupName")
 *             .ruleName("sdk-Rules-6571")
 *             .subscriptionName("sdk-Subscriptions-8691")
 *             .topicName("sdk-Topics-2081")
 *             .build());
 *     }
 * }
 * ```
 * ### RulesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.ServiceBus.Rule("rule", new()
 *     {
 *         NamespaceName = "sdk-Namespace-1319",
 *         ResourceGroupName = "resourceGroupName",
 *         RuleName = "sdk-Rules-6571",
 *         SubscriptionName = "sdk-Subscriptions-8691",
 *         TopicName = "sdk-Topics-2081",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewRule(ctx, "rule", &servicebus.RuleArgs{
 * 			NamespaceName:     pulumi.String("sdk-Namespace-1319"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			RuleName:          pulumi.String("sdk-Rules-6571"),
 * 			SubscriptionName:  pulumi.String("sdk-Subscriptions-8691"),
 * 			TopicName:         pulumi.String("sdk-Topics-2081"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Rule;
 * import com.pulumi.azurenative.servicebus.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .namespaceName("sdk-Namespace-1319")
 *             .resourceGroupName("resourceGroupName")
 *             .ruleName("sdk-Rules-6571")
 *             .subscriptionName("sdk-Subscriptions-8691")
 *             .topicName("sdk-Topics-2081")
 *             .build());
 *     }
 * }
 * ```
 * ### RulesCreateSqlFilter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.ServiceBus.Rule("rule", new()
 *     {
 *         FilterType = AzureNative.ServiceBus.FilterType.SqlFilter,
 *         NamespaceName = "sdk-Namespace-1319",
 *         ResourceGroupName = "resourceGroupName",
 *         RuleName = "sdk-Rules-6571",
 *         SqlFilter = new AzureNative.ServiceBus.Inputs.SqlFilterArgs
 *         {
 *             SqlExpression = "myproperty=test",
 *         },
 *         SubscriptionName = "sdk-Subscriptions-8691",
 *         TopicName = "sdk-Topics-2081",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewRule(ctx, "rule", &servicebus.RuleArgs{
 * 			FilterType:        pulumi.String(servicebus.FilterTypeSqlFilter),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-1319"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			RuleName:          pulumi.String("sdk-Rules-6571"),
 * 			SqlFilter: &servicebus.SqlFilterArgs{
 * 				SqlExpression: pulumi.String("myproperty=test"),
 * 			},
 * 			SubscriptionName: pulumi.String("sdk-Subscriptions-8691"),
 * 			TopicName:        pulumi.String("sdk-Topics-2081"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Rule;
 * import com.pulumi.azurenative.servicebus.RuleArgs;
 * import com.pulumi.azurenative.servicebus.inputs.SqlFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .filterType("SqlFilter")
 *             .namespaceName("sdk-Namespace-1319")
 *             .resourceGroupName("resourceGroupName")
 *             .ruleName("sdk-Rules-6571")
 *             .sqlFilter(SqlFilterArgs.builder()
 *                 .sqlExpression("myproperty=test")
 *                 .build())
 *             .subscriptionName("sdk-Subscriptions-8691")
 *             .topicName("sdk-Topics-2081")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Rule sdk-Rules-6571 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}
 * ```
 * @property action Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
 * @property correlationFilter Properties of correlationFilter
 * @property filterType Filter type that is evaluated against a BrokeredMessage.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property ruleName The rule name.
 * @property sqlFilter Properties of sqlFilter
 * @property subscriptionName The subscription name.
 * @property topicName The topic name.
 */
public data class RuleArgs(
    public val action: Output<ActionArgs>? = null,
    public val correlationFilter: Output<CorrelationFilterArgs>? = null,
    public val filterType: Output<Either<String, FilterType>>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val sqlFilter: Output<SqlFilterArgs>? = null,
    public val subscriptionName: Output<String>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.RuleArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.RuleArgs =
        com.pulumi.azurenative.servicebus.RuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .correlationFilter(correlationFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filterType(
                filterType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .sqlFilter(sqlFilter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subscriptionName(subscriptionName?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var action: Output<ActionArgs>? = null

    private var correlationFilter: Output<CorrelationFilterArgs>? = null

    private var filterType: Output<Either<String, FilterType>>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var sqlFilter: Output<SqlFilterArgs>? = null

    private var subscriptionName: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
     */
    @JvmName("cumaugdxwhiwlvyu")
    public suspend fun action(`value`: Output<ActionArgs>) {
        this.action = value
    }

    /**
     * @param value Properties of correlationFilter
     */
    @JvmName("rrpyevkdaathasco")
    public suspend fun correlationFilter(`value`: Output<CorrelationFilterArgs>) {
        this.correlationFilter = value
    }

    /**
     * @param value Filter type that is evaluated against a BrokeredMessage.
     */
    @JvmName("dtsmvpgikybvhudd")
    public suspend fun filterType(`value`: Output<Either<String, FilterType>>) {
        this.filterType = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("jblaidakqgnawjur")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("vlmqgkkolxawkalm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rule name.
     */
    @JvmName("blfygxckaxyeofxb")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Properties of sqlFilter
     */
    @JvmName("xfqmdxhcoudvlxtv")
    public suspend fun sqlFilter(`value`: Output<SqlFilterArgs>) {
        this.sqlFilter = value
    }

    /**
     * @param value The subscription name.
     */
    @JvmName("wnfwsjhjfceqdvtn")
    public suspend fun subscriptionName(`value`: Output<String>) {
        this.subscriptionName = value
    }

    /**
     * @param value The topic name.
     */
    @JvmName("csrnmjehsejnicwl")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
     */
    @JvmName("loipddewqituibbu")
    public suspend fun action(`value`: ActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
     */
    @JvmName("lfcfxcxeqxaysmyo")
    public suspend fun action(argument: suspend ActionArgsBuilder.() -> Unit) {
        val toBeMapped = ActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Properties of correlationFilter
     */
    @JvmName("loggbycatflxaoer")
    public suspend fun correlationFilter(`value`: CorrelationFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationFilter = mapped
    }

    /**
     * @param argument Properties of correlationFilter
     */
    @JvmName("ynwmjqthgogldabk")
    public suspend fun correlationFilter(argument: suspend CorrelationFilterArgsBuilder.() -> Unit) {
        val toBeMapped = CorrelationFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.correlationFilter = mapped
    }

    /**
     * @param value Filter type that is evaluated against a BrokeredMessage.
     */
    @JvmName("ofbmybhponuohmyc")
    public suspend fun filterType(`value`: Either<String, FilterType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterType = mapped
    }

    /**
     * @param value Filter type that is evaluated against a BrokeredMessage.
     */
    @JvmName("yflphjtsmgghqbub")
    public fun filterType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FilterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterType = mapped
    }

    /**
     * @param value Filter type that is evaluated against a BrokeredMessage.
     */
    @JvmName("cmaqscptyjrbydbh")
    public fun filterType(`value`: FilterType) {
        val toBeMapped = Either.ofRight<String, FilterType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterType = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("pasaodnxkisvdbel")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("dqolwvuyryuvsdvu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rule name.
     */
    @JvmName("uekhnyqahtypcigr")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Properties of sqlFilter
     */
    @JvmName("esyjiphxlpllwxpj")
    public suspend fun sqlFilter(`value`: SqlFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlFilter = mapped
    }

    /**
     * @param argument Properties of sqlFilter
     */
    @JvmName("lcrlbpmopalprltu")
    public suspend fun sqlFilter(argument: suspend SqlFilterArgsBuilder.() -> Unit) {
        val toBeMapped = SqlFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sqlFilter = mapped
    }

    /**
     * @param value The subscription name.
     */
    @JvmName("jbcvlbgsakgjtyub")
    public suspend fun subscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionName = mapped
    }

    /**
     * @param value The topic name.
     */
    @JvmName("vjgeyrgrhbtdgtpy")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        action = action,
        correlationFilter = correlationFilter,
        filterType = filterType,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        sqlFilter = sqlFilter,
        subscriptionName = subscriptionName,
        topicName = topicName,
    )
}
