@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.MessageCountDetailsResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SBClientAffinePropertiesResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicebus.kotlin.outputs.MessageCountDetailsResponse.Companion.toKotlin as messageCountDetailsResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SBClientAffinePropertiesResponse.Companion.toKotlin as sBClientAffinePropertiesResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Subscription].
 */
@PulumiTagMarker
public class SubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubscriptionArgs = SubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubscriptionArgsBuilder.() -> Unit) {
        val builder = SubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Subscription {
        val builtJavaResource = com.pulumi.azurenative.servicebus.Subscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Subscription(builtJavaResource)
    }
}

/**
 * Description of subscription resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### SubscriptionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscription = new AzureNative.ServiceBus.Subscription("subscription", new()
 *     {
 *         EnableBatchedOperations = true,
 *         NamespaceName = "sdk-Namespace-1349",
 *         ResourceGroupName = "ResourceGroup",
 *         SubscriptionName = "sdk-Subscriptions-2178",
 *         TopicName = "sdk-Topics-8740",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewSubscription(ctx, "subscription", &servicebus.SubscriptionArgs{
 * 			EnableBatchedOperations: pulumi.Bool(true),
 * 			NamespaceName:           pulumi.String("sdk-Namespace-1349"),
 * 			ResourceGroupName:       pulumi.String("ResourceGroup"),
 * 			SubscriptionName:        pulumi.String("sdk-Subscriptions-2178"),
 * 			TopicName:               pulumi.String("sdk-Topics-8740"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Subscription;
 * import com.pulumi.azurenative.servicebus.SubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscription = new Subscription("subscription", SubscriptionArgs.builder()
 *             .enableBatchedOperations(true)
 *             .namespaceName("sdk-Namespace-1349")
 *             .resourceGroupName("ResourceGroup")
 *             .subscriptionName("sdk-Subscriptions-2178")
 *             .topicName("sdk-Topics-8740")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Subscription sdk-Subscriptions-2178 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}
 * ```
 */
public class Subscription internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.Subscription,
) : KotlinCustomResource(javaResource, SubscriptionMapper) {
    /**
     * Last time there was a receive request to this subscription.
     */
    public val accessedAt: Output<String>
        get() = javaResource.accessedAt().applyValue({ args0 -> args0 })

    /**
     * ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
     */
    public val autoDeleteOnIdle: Output<String>?
        get() = javaResource.autoDeleteOnIdle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Properties specific to client affine subscriptions.
     */
    public val clientAffineProperties: Output<SBClientAffinePropertiesResponse>?
        get() = javaResource.clientAffineProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sBClientAffinePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Message count details
     */
    public val countDetails: Output<MessageCountDetailsResponse>
        get() = javaResource.countDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                messageCountDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Exact time the message was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
     */
    public val deadLetteringOnFilterEvaluationExceptions: Output<Boolean>?
        get() = javaResource.deadLetteringOnFilterEvaluationExceptions().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Value that indicates whether a subscription has dead letter support when a message expires.
     */
    public val deadLetteringOnMessageExpiration: Output<Boolean>?
        get() = javaResource.deadLetteringOnMessageExpiration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    public val defaultMessageTimeToLive: Output<String>?
        get() = javaResource.defaultMessageTimeToLive().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    public val duplicateDetectionHistoryTimeWindow: Output<String>?
        get() = javaResource.duplicateDetectionHistoryTimeWindow().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Value that indicates whether server-side batched operations are enabled.
     */
    public val enableBatchedOperations: Output<Boolean>?
        get() = javaResource.enableBatchedOperations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Queue/Topic name to forward the Dead Letter message
     */
    public val forwardDeadLetteredMessagesTo: Output<String>?
        get() = javaResource.forwardDeadLetteredMessagesTo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Queue/Topic name to forward the messages
     */
    public val forwardTo: Output<String>?
        get() = javaResource.forwardTo().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Value that indicates whether the subscription has an affinity to the client id.
     */
    public val isClientAffine: Output<Boolean>?
        get() = javaResource.isClientAffine().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
     */
    public val lockDuration: Output<String>?
        get() = javaResource.lockDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of maximum deliveries.
     */
    public val maxDeliveryCount: Output<Int>?
        get() = javaResource.maxDeliveryCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of messages.
     */
    public val messageCount: Output<Double>
        get() = javaResource.messageCount().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Value indicating if a subscription supports the concept of sessions.
     */
    public val requiresSession: Output<Boolean>?
        get() = javaResource.requiresSession().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enumerates the possible values for the status of a messaging entity.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The exact time the message was updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })
}

public object SubscriptionMapper : ResourceMapper<Subscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.Subscription::class == javaResource::class

    override fun map(javaResource: Resource): Subscription = Subscription(
        javaResource as
            com.pulumi.azurenative.servicebus.Subscription,
    )
}

/**
 * @see [Subscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Subscription].
 */
public suspend fun subscription(
    name: String,
    block: suspend SubscriptionResourceBuilder.() -> Unit,
): Subscription {
    val builder = SubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Subscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subscription(name: String): Subscription {
    val builder = SubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
