@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property subscriptionName The subscription name.
 * @property topicName The topic name.
 */
public data class GetSubscriptionPlainArgs(
    public val namespaceName: String,
    public val resourceGroupName: String,
    public val subscriptionName: String,
    public val topicName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetSubscriptionPlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetSubscriptionPlainArgs.builder()
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionName(subscriptionName.let({ args0 -> args0 }))
            .topicName(topicName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetSubscriptionPlainArgsBuilder internal constructor() {
    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionName: String? = null

    private var topicName: String? = null

    /**
     * @param value The namespace name
     */
    @JvmName("rlnxbetojiwwpjqr")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("oegryqtkmicldtfa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The subscription name.
     */
    @JvmName("uewqtviobnkohmcn")
    public suspend fun subscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subscriptionName = mapped
    }

    /**
     * @param value The topic name.
     */
    @JvmName("ikdwurpubmcpiwpd")
    public suspend fun topicName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicName = mapped
    }

    internal fun build(): GetSubscriptionPlainArgs = GetSubscriptionPlainArgs(
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionName = subscriptionName ?: throw PulumiNullFieldException("subscriptionName"),
        topicName = topicName ?: throw PulumiNullFieldException("topicName"),
    )
}
