@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.SBSkuArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.SkuName
import com.pulumi.azurenative.servicebus.kotlin.enums.SkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of the namespace.
 * @property capacity The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
 * @property name Name of this SKU.
 * @property tier The billing tier of this particular SKU.
 */
public data class SBSkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<Either<String, SkuName>>,
    public val tier: Output<Either<String, SkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.SBSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.SBSkuArgs =
        com.pulumi.azurenative.servicebus.inputs.SBSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SBSkuArgs].
 */
@PulumiTagMarker
public class SBSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<Either<String, SkuName>>? = null

    private var tier: Output<Either<String, SkuTier>>? = null

    /**
     * @param value The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
     */
    @JvmName("pfdsaloxkfpjjchc")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("axpaiqqwhgetjhvm")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("bynvuiudgofcywxq")
    public suspend fun tier(`value`: Output<Either<String, SkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
     */
    @JvmName("bqyqggjoavkbumfi")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("vbvtptcngbqodjgi")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("jsmqblxqrjyhgqrf")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of this SKU.
     */
    @JvmName("qbqgggnaawdyqcjr")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("bcisksmgroulscge")
    public suspend fun tier(`value`: Either<String, SkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("rdnolhbxbwewyrma")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The billing tier of this particular SKU.
     */
    @JvmName("kgivgddnykjiwcav")
    public fun tier(`value`: SkuTier) {
        val toBeMapped = Either.ofRight<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SBSkuArgs = SBSkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
