@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.UserAssignedIdentityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property userAssignedIdentity ARM ID of user Identity selected for encryption
 */
public data class UserAssignedIdentityPropertiesArgs(
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.UserAssignedIdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.UserAssignedIdentityPropertiesArgs = com.pulumi.azurenative.servicebus.inputs.UserAssignedIdentityPropertiesArgs.builder()
        .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedIdentityPropertiesArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityPropertiesArgsBuilder internal constructor() {
    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value ARM ID of user Identity selected for encryption
     */
    @JvmName("orjkduylwachrexn")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value ARM ID of user Identity selected for encryption
     */
    @JvmName("skwgdakcwpwyepkf")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): UserAssignedIdentityPropertiesArgs = UserAssignedIdentityPropertiesArgs(
        userAssignedIdentity = userAssignedIdentity,
    )
}
