@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
 * @property compatibilityLevel This property is reserved for future use. An integer value showing the compatibility level, currently hard-coded to 20.
 * @property requiresPreprocessing Value that indicates whether the rule action requires preprocessing.
 * @property sqlExpression SQL expression. e.g. MyProperty='ABC'
 */
public data class ActionResponse(
    public val compatibilityLevel: Int? = null,
    public val requiresPreprocessing: Boolean? = null,
    public val sqlExpression: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.ActionResponse): ActionResponse = ActionResponse(
            compatibilityLevel = javaType.compatibilityLevel().map({ args0 -> args0 }).orElse(null),
            requiresPreprocessing = javaType.requiresPreprocessing().map({ args0 -> args0 }).orElse(null),
            sqlExpression = javaType.sqlExpression().map({ args0 -> args0 }).orElse(null),
        )
    }
}
