@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ConnectionState information.
 * @property description Description of the connection state.
 * @property status Status of the connection.
 */
public data class ConnectionStateResponse(
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.ConnectionStateResponse): ConnectionStateResponse = ConnectionStateResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
