@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties to configure Encryption
 * @property keySource Enumerates the possible value of keySource for Encryption
 * @property keyVaultProperties Properties of KeyVault
 * @property requireInfrastructureEncryption Enable Infrastructure Encryption (Double Encryption)
 */
public data class EncryptionResponse(
    public val keySource: String? = null,
    public val keyVaultProperties: List<KeyVaultPropertiesResponse>? = null,
    public val requireInfrastructureEncryption: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.EncryptionResponse): EncryptionResponse = EncryptionResponse(
            keySource = javaType.keySource().map({ args0 -> args0 }).orElse(null),
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            requireInfrastructureEncryption = javaType.requireInfrastructureEncryption().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
