@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Description of a namespace resource.
 * @property alternateName Alternate name for namespace
 * @property createdAt The time the namespace was created
 * @property disableLocalAuth This property disables SAS authentication for the Service Bus namespace.
 * @property encryption Properties of BYOK Encryption description
 * @property id Resource Id
 * @property identity Properties of BYOK Identity description
 * @property location The Geo-location where the resource lives
 * @property metricId Identifier for Azure Insights metrics
 * @property minimumTlsVersion The minimum TLS version for the cluster to support, e.g. '1.2'
 * @property name Resource name
 * @property privateEndpointConnections List of private endpoint connections.
 * @property provisioningState Provisioning state of the namespace.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * @property serviceBusEndpoint Endpoint you can use to perform Service Bus operations.
 * @property sku Properties of SKU
 * @property status Status of the namespace.
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags
 * @property type Resource type
 * @property updatedAt The time the namespace was updated.
 * @property zoneRedundant Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
 */
public data class GetNamespaceResult(
    public val alternateName: String? = null,
    public val createdAt: String,
    public val disableLocalAuth: Boolean? = null,
    public val encryption: EncryptionResponse? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val metricId: String,
    public val minimumTlsVersion: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val serviceBusEndpoint: String,
    public val sku: SBSkuResponse? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val updatedAt: String,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetNamespaceResult): GetNamespaceResult = GetNamespaceResult(
            alternateName = javaType.alternateName().map({ args0 -> args0 }).orElse(null),
            createdAt = javaType.createdAt(),
            disableLocalAuth = javaType.disableLocalAuth().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            metricId = javaType.metricId(),
            minimumTlsVersion = javaType.minimumTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            serviceBusEndpoint = javaType.serviceBusEndpoint(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.SBSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
