@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Single item in a List or Get VirtualNetworkRules operation
 * @property id Resource Id
 * @property name Resource name
 * @property type Resource type
 * @property virtualNetworkSubnetId Resource ID of Virtual Network Subnet
 */
public data class GetNamespaceVirtualNetworkRuleResult(
    public val id: String,
    public val name: String,
    public val type: String,
    public val virtualNetworkSubnetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetNamespaceVirtualNetworkRuleResult): GetNamespaceVirtualNetworkRuleResult = GetNamespaceVirtualNetworkRuleResult(
            id = javaType.id(),
            name = javaType.name(),
            type = javaType.type(),
            virtualNetworkSubnetId = javaType.virtualNetworkSubnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
