@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Description of topic resource.
 * @property accessedAt Last time the message was sent, or a request was received, for this topic.
 * @property autoDeleteOnIdle ISO 8601 timespan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
 * @property countDetails Message count details
 * @property createdAt Exact time the message was created.
 * @property defaultMessageTimeToLive ISO 8601 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
 * @property duplicateDetectionHistoryTimeWindow ISO8601 timespan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
 * @property enableBatchedOperations Value that indicates whether server-side batched operations are enabled.
 * @property enableExpress Value that indicates whether Express Entities are enabled. An express topic holds a message in memory temporarily before writing it to persistent storage.
 * @property enablePartitioning Value that indicates whether the topic to be partitioned across multiple message brokers is enabled.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property maxMessageSizeInKilobytes Maximum size (in KB) of the message payload that can be accepted by the topic. This property is only used in Premium today and default is 1024.
 * @property maxSizeInMegabytes Maximum size of the topic in megabytes, which is the size of the memory allocated for the topic. Default is 1024.
 * @property name The name of the resource
 * @property requiresDuplicateDetection Value indicating if this topic requires duplicate detection.
 * @property sizeInBytes Size of the topic, in bytes.
 * @property status Enumerates the possible values for the status of a messaging entity.
 * @property subscriptionCount Number of subscriptions.
 * @property supportOrdering Value that indicates whether the topic supports ordering.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property updatedAt The exact time the message was updated.
 */
public data class GetTopicResult(
    public val accessedAt: String,
    public val autoDeleteOnIdle: String? = null,
    public val countDetails: MessageCountDetailsResponse,
    public val createdAt: String,
    public val defaultMessageTimeToLive: String? = null,
    public val duplicateDetectionHistoryTimeWindow: String? = null,
    public val enableBatchedOperations: Boolean? = null,
    public val enableExpress: Boolean? = null,
    public val enablePartitioning: Boolean? = null,
    public val id: String,
    public val location: String,
    public val maxMessageSizeInKilobytes: Double? = null,
    public val maxSizeInMegabytes: Int? = null,
    public val name: String,
    public val requiresDuplicateDetection: Boolean? = null,
    public val sizeInBytes: Double,
    public val status: String? = null,
    public val subscriptionCount: Int,
    public val supportOrdering: Boolean? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetTopicResult): GetTopicResult = GetTopicResult(
            accessedAt = javaType.accessedAt(),
            autoDeleteOnIdle = javaType.autoDeleteOnIdle().map({ args0 -> args0 }).orElse(null),
            countDetails = javaType.countDetails().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.MessageCountDetailsResponse.Companion.toKotlin(args0)
            }),
            createdAt = javaType.createdAt(),
            defaultMessageTimeToLive = javaType.defaultMessageTimeToLive().map({ args0 -> args0 }).orElse(null),
            duplicateDetectionHistoryTimeWindow = javaType.duplicateDetectionHistoryTimeWindow().map({ args0 ->
                args0
            }).orElse(null),
            enableBatchedOperations = javaType.enableBatchedOperations().map({ args0 -> args0 }).orElse(null),
            enableExpress = javaType.enableExpress().map({ args0 -> args0 }).orElse(null),
            enablePartitioning = javaType.enablePartitioning().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            maxMessageSizeInKilobytes = javaType.maxMessageSizeInKilobytes().map({ args0 ->
                args0
            }).orElse(null),
            maxSizeInMegabytes = javaType.maxSizeInMegabytes().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            requiresDuplicateDetection = javaType.requiresDuplicateDetection().map({ args0 ->
                args0
            }).orElse(null),
            sizeInBytes = javaType.sizeInBytes(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            subscriptionCount = javaType.subscriptionCount(),
            supportOrdering = javaType.supportOrdering().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
