@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Properties specific to client affine subscriptions.
 * @property clientId Indicates the Client ID of the application that created the client-affine subscription.
 * @property isDurable For client-affine subscriptions, this value indicates whether the subscription is durable or not.
 * @property isShared For client-affine subscriptions, this value indicates whether the subscription is shared or not.
 */
public data class SBClientAffinePropertiesResponse(
    public val clientId: String? = null,
    public val isDurable: Boolean? = null,
    public val isShared: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.SBClientAffinePropertiesResponse): SBClientAffinePropertiesResponse = SBClientAffinePropertiesResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            isDurable = javaType.isDurable().map({ args0 -> args0 }).orElse(null),
            isShared = javaType.isShared().map({ args0 -> args0 }).orElse(null),
        )
    }
}
