@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SKU of the namespace.
 * @property capacity The specified messaging units for the tier. For Premium tier, capacity are 1,2 and 4.
 * @property name Name of this SKU.
 * @property tier The billing tier of this particular SKU.
 */
public data class SBSkuResponse(
    public val capacity: Int? = null,
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.SBSkuResponse): SBSkuResponse = SBSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
