@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.StatefulServicePropertiesArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.StatelessServicePropertiesArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The service resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview, 2024-02-01-preview, 2024-04-01.
 * ## Example Usage
 * ### Put a service with maximum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterService = new AzureNative.ServiceFabric.ManagedClusterService("managedClusterService", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         Properties = new AzureNative.ServiceFabric.Inputs.StatelessServicePropertiesArgs
 *         {
 *             CorrelationScheme = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ServiceCorrelationArgs
 *                 {
 *                     Scheme = AzureNative.ServiceFabric.ServiceCorrelationScheme.AlignedAffinity,
 *                     ServiceName = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applications/myApp/services/myService1",
 *                 },
 *             },
 *             DefaultMoveCost = AzureNative.ServiceFabric.MoveCost.Medium,
 *             InstanceCount = 5,
 *             MinInstanceCount = 3,
 *             MinInstancePercentage = 30,
 *             PartitionDescription = new AzureNative.ServiceFabric.Inputs.SingletonPartitionSchemeArgs
 *             {
 *                 PartitionScheme = "Singleton",
 *             },
 *             PlacementConstraints = "NodeType==frontend",
 *             ScalingPolicies = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ScalingPolicyArgs
 *                 {
 *                     ScalingMechanism = new AzureNative.ServiceFabric.Inputs.PartitionInstanceCountScaleMechanismArgs
 *                     {
 *                         Kind = "ScalePartitionInstanceCount",
 *                         MaxInstanceCount = 9,
 *                         MinInstanceCount = 3,
 *                         ScaleIncrement = 2,
 *                     },
 *                     ScalingTrigger = new AzureNative.ServiceFabric.Inputs.AveragePartitionLoadScalingTriggerArgs
 *                     {
 *                         Kind = "AveragePartitionLoadTrigger",
 *                         LowerLoadThreshold = 2,
 *                         MetricName = "metricName",
 *                         ScaleInterval = "00:01:00",
 *                         UpperLoadThreshold = 8,
 *                     },
 *                 },
 *             },
 *             ServiceDnsName = "myservicednsname.myApp",
 *             ServiceKind = "Stateless",
 *             ServiceLoadMetrics = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ServiceLoadMetricArgs
 *                 {
 *                     DefaultLoad = 3,
 *                     Name = "metric1",
 *                     Weight = AzureNative.ServiceFabric.ServiceLoadMetricWeight.Low,
 *                 },
 *             },
 *             ServicePackageActivationMode = AzureNative.ServiceFabric.ServicePackageActivationMode.SharedProcess,
 *             ServicePlacementPolicies = new[]
 *             {
 *                 new AzureNative.ServiceFabric.Inputs.ServicePlacementNonPartiallyPlaceServicePolicyArgs
 *                 {
 *                     Type = "NonPartiallyPlaceService",
 *                 },
 *             },
 *             ServiceTypeName = "myServiceType",
 *         },
 *         ResourceGroupName = "resRg",
 *         ServiceName = "myService",
 *         Tags =
 *         {
 *             { "a", "b" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterService(ctx, "managedClusterService", &servicefabric.ManagedClusterServiceArgs{
 * 			ApplicationName: pulumi.String("myApp"),
 * 			ClusterName:     pulumi.String("myCluster"),
 * 			Location:        pulumi.String("eastus"),
 * 			Properties: servicefabric.StatelessServiceProperties{
 * 				CorrelationScheme: []servicefabric.ServiceCorrelation{
 * 					{
 * 						Scheme:      servicefabric.ServiceCorrelationSchemeAlignedAffinity,
 * 						ServiceName: "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applications/myApp/services/myService1",
 * 					},
 * 				},
 * 				DefaultMoveCost:       servicefabric.MoveCostMedium,
 * 				InstanceCount:         5,
 * 				MinInstanceCount:      3,
 * 				MinInstancePercentage: 30,
 * 				PartitionDescription: servicefabric.SingletonPartitionScheme{
 * 					PartitionScheme: "Singleton",
 * 				},
 * 				PlacementConstraints: "NodeType==frontend",
 * 				ScalingPolicies: []servicefabric.ScalingPolicy{
 * 					{
 * 						ScalingMechanism: {
 * 							Kind:             "ScalePartitionInstanceCount",
 * 							MaxInstanceCount: 9,
 * 							MinInstanceCount: 3,
 * 							ScaleIncrement:   2,
 * 						},
 * 						ScalingTrigger: {
 * 							Kind:               "AveragePartitionLoadTrigger",
 * 							LowerLoadThreshold: 2,
 * 							MetricName:         "metricName",
 * 							ScaleInterval:      "00:01:00",
 * 							UpperLoadThreshold: 8,
 * 						},
 * 					},
 * 				},
 * 				ServiceDnsName: "myservicednsname.myApp",
 * 				ServiceKind:    "Stateless",
 * 				ServiceLoadMetrics: []servicefabric.ServiceLoadMetric{
 * 					{
 * 						DefaultLoad: 3,
 * 						Name:        "metric1",
 * 						Weight:      servicefabric.ServiceLoadMetricWeightLow,
 * 					},
 * 				},
 * 				ServicePackageActivationMode: servicefabric.ServicePackageActivationModeSharedProcess,
 * 				ServicePlacementPolicies: []interface{}{
 * 					servicefabric.ServicePlacementNonPartiallyPlaceServicePolicy{
 * 						Type: "NonPartiallyPlaceService",
 * 					},
 * 				},
 * 				ServiceTypeName: "myServiceType",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ServiceName:       pulumi.String("myService"),
 * 			Tags: pulumi.StringMap{
 * 				"a": pulumi.String("b"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterService;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterService = new ManagedClusterService("managedClusterService", ManagedClusterServiceArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .properties(StatelessServicePropertiesArgs.builder()
 *                 .correlationScheme(ServiceCorrelationArgs.builder()
 *                     .scheme("AlignedAffinity")
 *                     .serviceName("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applications/myApp/services/myService1")
 *                     .build())
 *                 .defaultMoveCost("Medium")
 *                 .instanceCount(5)
 *                 .minInstanceCount(3)
 *                 .minInstancePercentage(30)
 *                 .partitionDescription(SingletonPartitionSchemeArgs.builder()
 *                     .partitionScheme("Singleton")
 *                     .build())
 *                 .placementConstraints("NodeType==frontend")
 *                 .scalingPolicies(ScalingPolicyArgs.builder()
 *                     .scalingMechanism(AddRemoveIncrementalNamedPartitionScalingMechanismArgs.builder()
 *                         .kind("ScalePartitionInstanceCount")
 *                         .maxInstanceCount(9)
 *                         .minInstanceCount(3)
 *                         .scaleIncrement(2)
 *                         .build())
 *                     .scalingTrigger(AveragePartitionLoadScalingTriggerArgs.builder()
 *                         .kind("AveragePartitionLoadTrigger")
 *                         .lowerLoadThreshold(2)
 *                         .metricName("metricName")
 *                         .scaleInterval("00:01:00")
 *                         .upperLoadThreshold(8)
 *                         .build())
 *                     .build())
 *                 .serviceDnsName("myservicednsname.myApp")
 *                 .serviceKind("Stateless")
 *                 .serviceLoadMetrics(ServiceLoadMetricArgs.builder()
 *                     .defaultLoad(3)
 *                     .name("metric1")
 *                     .weight("Low")
 *                     .build())
 *                 .servicePackageActivationMode("SharedProcess")
 *                 .servicePlacementPolicies(ServicePlacementNonPartiallyPlaceServicePolicyArgs.builder()
 *                     .type("NonPartiallyPlaceService")
 *                     .build())
 *                 .serviceTypeName("myServiceType")
 *                 .build())
 *             .resourceGroupName("resRg")
 *             .serviceName("myService")
 *             .tags(Map.of("a", "b"))
 *             .build());
 *     }
 * }
 * ```
 * ### Put a service with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterService = new AzureNative.ServiceFabric.ManagedClusterService("managedClusterService", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         Properties = new AzureNative.ServiceFabric.Inputs.StatelessServicePropertiesArgs
 *         {
 *             InstanceCount = 1,
 *             PartitionDescription = new AzureNative.ServiceFabric.Inputs.SingletonPartitionSchemeArgs
 *             {
 *                 PartitionScheme = "Singleton",
 *             },
 *             ServiceKind = "Stateless",
 *             ServiceTypeName = "myServiceType",
 *         },
 *         ResourceGroupName = "resRg",
 *         ServiceName = "myService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterService(ctx, "managedClusterService", &servicefabric.ManagedClusterServiceArgs{
 * 			ApplicationName: pulumi.String("myApp"),
 * 			ClusterName:     pulumi.String("myCluster"),
 * 			Location:        pulumi.String("eastus"),
 * 			Properties: servicefabric.StatelessServiceProperties{
 * 				InstanceCount: 1,
 * 				PartitionDescription: servicefabric.SingletonPartitionScheme{
 * 					PartitionScheme: "Singleton",
 * 				},
 * 				ServiceKind:     "Stateless",
 * 				ServiceTypeName: "myServiceType",
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ServiceName:       pulumi.String("myService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterService;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterService = new ManagedClusterService("managedClusterService", ManagedClusterServiceArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .properties(StatelessServicePropertiesArgs.builder()
 *                 .instanceCount(1)
 *                 .partitionDescription(SingletonPartitionSchemeArgs.builder()
 *                     .partitionScheme("Singleton")
 *                     .build())
 *                 .serviceKind("Stateless")
 *                 .serviceTypeName("myServiceType")
 *                 .build())
 *             .resourceGroupName("resRg")
 *             .serviceName("myService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterService myService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applications/{applicationName}/services/{serviceName}
 * ```
 * @property applicationName The name of the application resource.
 * @property clusterName The name of the cluster resource.
 * @property location Resource location depends on the parent resource.
 * @property properties The service resource properties.
 * @property resourceGroupName The name of the resource group.
 * @property serviceName The name of the service resource in the format of {applicationName}~{serviceName}.
 * @property tags Azure resource tags.
 */
public data class ManagedClusterServiceArgs(
    public val applicationName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<Either<StatefulServicePropertiesArgs, StatelessServicePropertiesArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs =
        com.pulumi.azurenative.servicefabric.ManagedClusterServiceArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterServiceArgs].
 */
@PulumiTagMarker
public class ManagedClusterServiceArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties:
        Output<Either<StatefulServicePropertiesArgs, StatelessServicePropertiesArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the application resource.
     */
    @JvmName("axiqgbqrgxdvqdkh")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("bdaxacspyhgvmfhj")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("uwikxdxlhiorbmvk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The service resource properties.
     */
    @JvmName("wufnnctwpoghmyot")
    public suspend fun properties(`value`: Output<Either<StatefulServicePropertiesArgs, StatelessServicePropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vbamvpjwlxxfyifs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service resource in the format of {applicationName}~{serviceName}.
     */
    @JvmName("ewedmmwsejkwfgnj")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("oueaxkkqboggeepe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the application resource.
     */
    @JvmName("yufhpmkodumdbrkp")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("vknodypiopgbjmev")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("lfgtstdfrocrwfar")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The service resource properties.
     */
    @JvmName("gewtviqgyjtiugex")
    public suspend fun properties(`value`: Either<StatefulServicePropertiesArgs, StatelessServicePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The service resource properties.
     */
    @JvmName("kwdooywxyerjxima")
    public fun properties(`value`: StatefulServicePropertiesArgs) {
        val toBeMapped = Either.ofLeft<
            StatefulServicePropertiesArgs,
            StatelessServicePropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The service resource properties.
     */
    @JvmName("byanqropiybxupps")
    public fun properties(`value`: StatelessServicePropertiesArgs) {
        val toBeMapped = Either.ofRight<
            StatefulServicePropertiesArgs,
            StatelessServicePropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jvbtdbtilyvwddbh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service resource in the format of {applicationName}~{serviceName}.
     */
    @JvmName("gfhjxstpavffsdnk")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("aujugjauyhunllnv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("ybafpilmpeuktfwb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedClusterServiceArgs = ManagedClusterServiceArgs(
        applicationName = applicationName,
        clusterName = clusterName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        tags = tags,
    )
}
