@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates when new cluster runtime version upgrades will be applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'.
 */
public enum class ClusterUpgradeCadence(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeCadence,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeCadence> {
    /**
     * Cluster upgrade starts immediately after a new version is rolled out. Recommended for Test/Dev clusters.
     */
    Wave0(com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeCadence.Wave0),

    /**
     * Cluster upgrade starts 7 days after a new version is rolled out. Recommended for Pre-prod clusters.
     */
    Wave1(com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeCadence.Wave1),

    /**
     * Cluster upgrade starts 14 days after a new version is rolled out. Recommended for Production clusters.
     */
    Wave2(com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeCadence.Wave2),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeCadence =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ClusterUpgradeCadence): ClusterUpgradeCadence = ClusterUpgradeCadence.values().first { it.javaValue == javaType }
    }
}
