@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Managed data disk type. Specifies the storage account type for the managed disk
 */
public enum class DiskType(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.DiskType,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.DiskType> {
    /**
     * Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent access.
     */
    Standard_LRS(com.pulumi.azurenative.servicefabric.enums.DiskType.Standard_LRS),

    /**
     * Standard SSD locally redundant storage. Best for web servers, lightly used enterprise applications and dev/test.
     */
    StandardSSD_LRS(com.pulumi.azurenative.servicefabric.enums.DiskType.StandardSSD_LRS),

    /**
     * Premium SSD locally redundant storage. Best for production and performance sensitive workloads.
     */
    Premium_LRS(com.pulumi.azurenative.servicefabric.enums.DiskType.Premium_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.DiskType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.DiskType): DiskType =
            DiskType.values().first { it.javaValue == javaType }
    }
}
