@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Available cluster add-on features
 */
public enum class ManagedClusterAddOnFeature(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ManagedClusterAddOnFeature,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ManagedClusterAddOnFeature> {
    /**
     * Dns service
     */
    DnsService(com.pulumi.azurenative.servicefabric.enums.ManagedClusterAddOnFeature.DnsService),

    /**
     * Backup and restore service
     */
    BackupRestoreService(com.pulumi.azurenative.servicefabric.enums.ManagedClusterAddOnFeature.BackupRestoreService),

    /**
     * Resource monitor service
     */
    ResourceMonitorService(com.pulumi.azurenative.servicefabric.enums.ManagedClusterAddOnFeature.ResourceMonitorService),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ManagedClusterAddOnFeature =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ManagedClusterAddOnFeature): ManagedClusterAddOnFeature =
            ManagedClusterAddOnFeature.values().first { it.javaValue == javaType }
    }
}
