@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of managed identity for the resource.
 */
public enum class ManagedIdentityType(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType> {
    /**
     * Indicates that no identity is associated with the resource.
     */
    None(com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType.None),

    /**
     * Indicates that system assigned identity is associated with the resource.
     */
    SystemAssigned(com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType.SystemAssigned),

    /**
     * Indicates that user assigned identity is associated with the resource.
     */
    UserAssigned(com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType.UserAssigned),

    /**
     * Indicates that both system assigned and user assigned identity are associated with the resource.
     */
    SystemAssigned_UserAssigned(com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ManagedIdentityType): ManagedIdentityType = ManagedIdentityType.values().first { it.javaValue == javaType }
    }
}
