@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The mode used to monitor health during a rolling upgrade. The values are Monitored, and UnmonitoredAuto.
 */
public enum class RollingUpgradeMode(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.RollingUpgradeMode,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.RollingUpgradeMode> {
    /**
     * The upgrade will stop after completing each upgrade domain and automatically monitor health before proceeding. The value is 0.
     */
    Monitored(com.pulumi.azurenative.servicefabric.enums.RollingUpgradeMode.Monitored),

    /**
     * The upgrade will proceed automatically without performing any health monitoring. The value is 1.
     */
    UnmonitoredAuto(com.pulumi.azurenative.servicefabric.enums.RollingUpgradeMode.UnmonitoredAuto),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.RollingUpgradeMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.RollingUpgradeMode): RollingUpgradeMode = RollingUpgradeMode.values().first { it.javaValue == javaType }
    }
}
