@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
 */
public enum class ServiceCorrelationScheme(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ServiceCorrelationScheme,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ServiceCorrelationScheme> {
    /**
     * Aligned affinity ensures that the primaries of the partitions of the affinitized services are collocated on the same nodes. This is the default and is the same as selecting the Affinity scheme. The value is 0.
     */
    AlignedAffinity(com.pulumi.azurenative.servicefabric.enums.ServiceCorrelationScheme.AlignedAffinity),

    /**
     * Non-Aligned affinity guarantees that all replicas of each service will be placed on the same nodes. Unlike Aligned Affinity, this does not guarantee that replicas of particular role will be collocated. The value is 1.
     */
    NonAlignedAffinity(com.pulumi.azurenative.servicefabric.enums.ServiceCorrelationScheme.NonAlignedAffinity),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ServiceCorrelationScheme =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ServiceCorrelationScheme): ServiceCorrelationScheme =
            ServiceCorrelationScheme.values().first { it.javaValue == javaType }
    }
}
