@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The activation Mode of the service package
 */
public enum class ServicePackageActivationMode(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.ServicePackageActivationMode,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.ServicePackageActivationMode> {
    /**
     * Indicates the application package activation mode will use shared process.
     */
    SharedProcess(com.pulumi.azurenative.servicefabric.enums.ServicePackageActivationMode.SharedProcess),

    /**
     * Indicates the application package activation mode will use exclusive process.
     */
    ExclusiveProcess(com.pulumi.azurenative.servicefabric.enums.ServicePackageActivationMode.ExclusiveProcess),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.ServicePackageActivationMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.ServicePackageActivationMode): ServicePackageActivationMode =
            ServicePackageActivationMode.values().first { it.javaValue == javaType }
    }
}
