@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sku Name.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.servicefabric.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.enums.SkuName> {
    /**
     * Basic requires a minimum of 3 nodes and allows only 1 node type.
     */
    Basic(com.pulumi.azurenative.servicefabric.enums.SkuName.Basic),

    /**
     * Requires a minimum of 5 nodes and allows 1 or more node type.
     */
    Standard(com.pulumi.azurenative.servicefabric.enums.SkuName.Standard),
    ;

    override fun toJava(): com.pulumi.azurenative.servicefabric.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
