@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.AzureActiveDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The settings to enable AAD authentication on the cluster.
 * @property clientApplication Azure active directory client application id.
 * @property clusterApplication Azure active directory cluster application id.
 * @property tenantId Azure active directory tenant id.
 */
public data class AzureActiveDirectoryArgs(
    public val clientApplication: Output<String>? = null,
    public val clusterApplication: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.AzureActiveDirectoryArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.AzureActiveDirectoryArgs =
        com.pulumi.azurenative.servicefabric.inputs.AzureActiveDirectoryArgs.builder()
            .clientApplication(clientApplication?.applyValue({ args0 -> args0 }))
            .clusterApplication(clusterApplication?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureActiveDirectoryArgs].
 */
@PulumiTagMarker
public class AzureActiveDirectoryArgsBuilder internal constructor() {
    private var clientApplication: Output<String>? = null

    private var clusterApplication: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Azure active directory client application id.
     */
    @JvmName("nagdcaptvicavspx")
    public suspend fun clientApplication(`value`: Output<String>) {
        this.clientApplication = value
    }

    /**
     * @param value Azure active directory cluster application id.
     */
    @JvmName("frtvdmvupdegatkf")
    public suspend fun clusterApplication(`value`: Output<String>) {
        this.clusterApplication = value
    }

    /**
     * @param value Azure active directory tenant id.
     */
    @JvmName("kqckxlnwjnyyhogq")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Azure active directory client application id.
     */
    @JvmName("xtidfkwjkdtsqxjr")
    public suspend fun clientApplication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientApplication = mapped
    }

    /**
     * @param value Azure active directory cluster application id.
     */
    @JvmName("cxrrrcqsghshjtuc")
    public suspend fun clusterApplication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterApplication = mapped
    }

    /**
     * @param value Azure active directory tenant id.
     */
    @JvmName("mhesvxkofchguwiu")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AzureActiveDirectoryArgs = AzureActiveDirectoryArgs(
        clientApplication = clientApplication,
        clusterApplication = clusterApplication,
        tenantId = tenantId,
    )
}
