@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationTypeName The name of the application type name resource.
 * @property clusterName The name of the cluster resource.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetManagedClusterApplicationTypePlainArgs(
    public val applicationTypeName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypePlainArgs =
        com.pulumi.azurenative.servicefabric.inputs.GetManagedClusterApplicationTypePlainArgs.builder()
            .applicationTypeName(applicationTypeName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedClusterApplicationTypePlainArgs].
 */
@PulumiTagMarker
public class GetManagedClusterApplicationTypePlainArgsBuilder internal constructor() {
    private var applicationTypeName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the application type name resource.
     */
    @JvmName("miasarcuamysbejv")
    public suspend fun applicationTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationTypeName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("nirfkmxcacopextx")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("khpyxffagpyoqgbc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedClusterApplicationTypePlainArgs =
        GetManagedClusterApplicationTypePlainArgs(
            applicationTypeName = applicationTypeName ?: throw PulumiNullFieldException("applicationTypeName"),
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
